/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.cmdhelpers.FspCecHvConfigStateAndPowerPolicy;
import com.ibm.hsc.fsp.cmdhelpers.FspCecState;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmCecStateChangeAct {
    private OmCecMgr mCecMgr;
    private static final int CEC_STATE_READY = 1;
    private static final int FSP_FAIL_OVER = 33;
    static final int STATE_NO_CONN = 254;
    private static final int STATE_INCOMPLETE = 253;
    private static final int STATE_RECOVERY = 251;
    static final int STATE_INCOMPATIBLE = 250;
    private static final int FSP_STATE_SUM_FAIL_OVER = 32768;
    private static final int ASYNC_OPER = 0;
    private static final int NEW_CONN_OPER = 1;
    private static final int REBUILD_FROM_CLIENT = 2;
    private static final int STATE_UNAAILABLE = 252;
    private static final String CEC_STATE_SUMMARY = "CEC_STATE_SUMMARY";
    private static final String CEC_RUN_STATE = "CEC_RUN_STATE";
    private static final String CEC_POWER_STATE = "CEC_POWER_STATE";
    private static final String MAX_PHYP_CMD = "MAX_HYP_COMMAND";
    private static final int CEC_PHYP_FUNCTIONAL = 15;
    private static final int PHYP_STATE_IPLING = 1;
    private static final int PHYP_STATE_STANDBY = 3;
    private static final int PHYP_STATE_NORMAL = 4;
    private static final int COD_STATE_CTA = 129;
    private static final int COD_STATE_RECOVERY = 130;
    private static final int COD_STATE_NORMAL = 255;
    private static final int[] PHYP_STATE_TO_CEC_STATE = new int[]{-1, 6, -1, 17, 1};

    public OmCecStateChangeAct(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
    }

    private int handlePhypStateChange(boolean bl) {
        int n = 253;
        try {
            FspCecHvConfigStateAndPowerPolicy fspCecHvConfigStateAndPowerPolicy = this.mCecMgr.getCmdHelper().getHypervisorConfigStateAndPowerPolicy();
            n = fspCecHvConfigStateAndPowerPolicy.getState().intValue();
            Boolean bl2 = null;
            if (fspCecHvConfigStateAndPowerPolicy.getPowerOffPolicy().byteValue() == 0) {
                bl2 = new Boolean(false);
            } else if (fspCecHvConfigStateAndPowerPolicy.getPowerOffPolicy().byteValue() == 1) {
                bl2 = new Boolean(true);
            }
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            boolean bl3 = false;
            System.out.println("update power policy");
            if (this.mCecMgr.getObject().setProperty(R50ComputerSystem.Index_PowerOffPolicy, (Object)bl2)) {
                System.out.println("[OM]PowerOffPolicy = " + bl2);
                bl3 = true;
            }
            System.out.println("update cec mode");
            if (this.mCecMgr.getObject().setProperty(R50ComputerSystem.Index_Mode, (Object)fspCecHvConfigStateAndPowerPolicy.getMode())) {
                bl3 = true;
                System.out.println("[OM]Mode = " + fspCecHvConfigStateAndPowerPolicy.getMode());
            }
            System.out.println("phypState " + n);
            if (n == 4 || n == 3) {
                bl3 = this.mCecMgr.updateServiceLparId(bl);
            } else {
                System.out.println("phyp state is not normal or standby, don't need to update service lpar id");
            }
            if (bl3) {
                this.mCecMgr.sendModifiedIndication(rObject);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error detected. Method to return incomplete state");
            throwable.printStackTrace();
            n = 253;
        }
        return n;
    }

    int getPhypCecState() {
        return this.getPhypCecState(false);
    }

    private int getPhypCecState(boolean bl) {
        int n = 253;
        int n2 = this.handlePhypStateChange(bl);
        if (n2 == 253) {
            return n2;
        }
        try {
            if (n2 == 3) {
                BitSet bitSet = this.mCecMgr.getCmdHelper().getHypervisorCapabilities();
                if (bitSet.get(29)) {
                    int n3 = this.mCecMgr.getCmdHelper().getCodState().intValue();
                    if (n3 == 130) {
                        n = 16;
                    } else if (n3 == 255 || n3 == 170) {
                        n = 17;
                    } else if (n3 == 129) {
                        n = 15;
                    } else {
                        System.out.println("invalid COD state " + n3);
                        System.out.println("return incomplete as cec state");
                    }
                } else {
                    n = 17;
                }
            } else {
                n = PHYP_STATE_TO_CEC_STATE[n2];
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            n = PHYP_STATE_TO_CEC_STATE[n2];
        }
        return n;
    }

    boolean handleCecStateChange(boolean bl, FspLockHelper fspLockHelper) {
        int n = 1;
        int n2 = -1;
        try {
            n2 = ((UnsignedInt8)this.mCecMgr.getProperty("State")).intValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            n = 253;
        }
        int n3 = -1;
        System.out.println("fromPhyp: " + bl);
        if (n != 253) {
            if (!bl) {
                try {
                    n = this.getCecStateFromFSP();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    n = 253;
                }
            }
            boolean bl2 = false;
            if (n == 1 || bl) {
                try {
                    UnsignedInt8 unsignedInt8 = (UnsignedInt8)this.mCecMgr.getObject().getProperty(R50ComputerSystem.Index_Mode);
                    n = this.getPhypCecState(true);
                    UnsignedInt8 unsignedInt82 = (UnsignedInt8)this.mCecMgr.getObject().getProperty(R50ComputerSystem.Index_Mode);
                    bl2 = unsignedInt8 != null && unsignedInt82 != null && unsignedInt8.intValue() != 0 && !unsignedInt8.equals((Object)unsignedInt82);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.mCecMgr.setHypervisorRunning(n == 1 || n == 17 || n == 16);
            n = this.getChangedCecState(n2, n, 0);
            if (n == n2 && !bl2) {
                return false;
            }
            if (n == 1 || n == 17 || n == 16 || bl2) {
                this.mCecMgr.rebuildFromPowerOn(fspLockHelper);
                return true;
            }
        }
        try {
            RObject rObject = (RObject)this.mCecMgr.getObject().clone();
            if (!this.setCecState(n2, n)) {
                return false;
            }
            this.mCecMgr.sendModifiedIndication(rObject);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public boolean setCecState(int n, int n2) throws RException {
        UnsignedInt8 unsignedInt8;
        boolean bl = false;
        if (n == -1 && (unsignedInt8 = (UnsignedInt8)this.mCecMgr.getProperty("State")) != null) {
            n = unsignedInt8.intValue();
        }
        if (n == n2) {
            return false;
        }
        if ((n == 1 || n == 17 || n == -1) && n2 != 1 && n2 != 17) {
            System.out.println("set lpar states to unavailable");
            this.updatePartitionStates(252);
        } else {
            System.out.println("set cec state old state " + n + " new state " + n2);
        }
        if (n2 == 254 || n2 == 250) {
            System.out.println("set off cec src");
            this.mCecMgr.setHypervisorRunning(false);
        }
        if (this.mCecMgr.setProperty("State", (Object)new UnsignedInt8((short)n2))) {
            bl = true;
        }
        return bl;
    }

    public void updatePartitionStates(int n) throws RException {
        Hashtable hashtable = this.mCecMgr.getLparMgrHash();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            OmLparMgr omLparMgr = (OmLparMgr)hashtable.get(string);
            RObject rObject = (RObject)omLparMgr.getObject().clone();
            if (!omLparMgr.setLparState(n)) continue;
            omLparMgr.sendModifiedIndication(rObject);
        }
    }

    public int getCecStateFromFspAndPhyp() throws PIHscServerException, PIHscCmdMgrException {
        int n = this.getCecStateFromFSP();
        if (n == 1) {
            n = this.getPhypCecState();
        }
        this.mCecMgr.setHypervisorRunning(n == 1 || n == 17 || n == 16);
        return n;
    }

    private int getCecStateFromFSP() throws PIHscServerException, PIHscCmdMgrException {
        FspCecState fspCecState = null;
        System.out.println("using getCecStateV3");
        fspCecState = this.mCecMgr.getCmdHelper().getCecState();
        System.out.println("in OmCecStateChangeAct");
        int n = fspCecState.getCecStateSummary().intValue();
        System.out.println("stateSum: " + n);
        if ((n & 0x8000) != 0) {
            return 33;
        }
        int n2 = fspCecState.getCecRunState().intValue();
        System.out.println("runState: " + n2);
        int n3 = fspCecState.getCecPowerState().intValue();
        System.out.println("powerState: " + n3);
        int n4 = fspCecState.getMaxHypCommands().intValue();
        System.out.println("maxPHYPCmd: " + n4);
        int[][] nArrayArray = new int[][]{{3, -1, -1, 12, -1, -1, -1, -1, -1, -1, 12, -1, -1, -1, -1, -1}, {6, 6, 6, 12, 13, -1, -1, 32, 6, 13, 12, -1, -1, -1, -1, 1}, {6, -1, -1, 12, -1, 6, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        int n5 = nArrayArray[n3][n2];
        if (n5 == -1) {
            throw new RuntimeException("invalid power state " + n3 + " and run state " + n2 + " combination.");
        }
        return n5;
    }

    public int getCecStateV1FromFSP() throws PIHscServerException, PIHscCmdMgrException {
        FspCecState fspCecState = this.mCecMgr.getCmdHelper().getCecState();
        int n = fspCecState.getCecPowerState().intValue();
        int n2 = fspCecState.getMaxHypCommands().intValue();
        this.mCecMgr.setHypervisorRunning(n2 > 0);
        return n;
    }

    public int getCecState(int n) throws RException, PIHscServerException, PIHscCmdMgrException {
        int n2 = this.getCecStateFromFSP();
        int n3 = ((UnsignedInt32)this.mCecMgr.getProperty("State")).intValue();
        if (n2 == 1) {
            n2 = this.getPhypCecState();
        }
        this.mCecMgr.setHypervisorRunning(n2 == 1 || n2 == 17 || n2 == 16);
        n2 = this.getChangedCecState(n3, n2, n);
        return n2;
    }

    public int getChangedCecState(int n, int n2, int n3) {
        if (n3 == 0) {
            if (n2 == 254 || n == 254) {
                return 254;
            }
            if (n2 == 33) {
                return n2;
            }
        }
        return n2;
    }
}

